<%@ Page Language="C#" MasterPageFile="~/usrManager.master" AutoEventWireup="true" Debug ="true" Inherits="Users_User_AddUsr" Title="Untitled Page" Codebehind="AddUsr.aspx.cs" %>
<asp:Content ID="oContent" ContentPlaceHolderID="oBody" runat="Server">
<script language="javascript" type="text/javascript" src="../../Includes/JS_Functions.js" enableviewstate="false"></script>
<script language="javascript" type="text/javascript" src="../../Includes/easyAjax.js" enableviewstate="false"></script>
<script language="javascript" type="text/javascript">
    //<![CDATA[
    function ValidateEmptyAddNewUsr(txtId, txtPwd, txtConfirmPwd, txtFirstName,
                              txtLastName, txtEMail, strMsgUserID, strMsgInvalidID,
                              strMsgPassword, strMsgPasswordMatch, strMsgFirstName,
                              strMsgLastName, strMsgEMail, strMsgAssignOrganizations,
                              pValidateVerticals, msgTheLicense, msgTheUserTypeMain,
                              msgTheUserTypeSecondary, strMsgAssignVerticals)
    {
      //Declaracion de variables
      var objTxtId;
      var objTxtPwd;
      var objTxtConfirmPwd;
      var objTxtFirstName;
      var objTxtLastName;
      var objTxtEMail;
      var filter;
      
      //Asignacion de objetos
      objTxtId = document.getElementById(txtId);
      objTxtPwd = document.getElementById(txtPwd);
      objTxtConfirmPwd = document.getElementById(txtConfirmPwd);
      objTxtFirstName = document.getElementById(txtFirstName);
      objTxtLastName = document.getElementById(txtLastName);
      objTxtEMail = document.getElementById(txtEMail);
      
      //Validacion Id de Usuario
      if (objTxtId.value.trim() == '')
      {
        alert(strMsgUserID);
        objTxtId.select();
        return false;
      }
      else
      {
        filter = /^[a-zA-Z0-9_\-\.]+$/;
            
        if (filter.test(objTxtId.value.trim()) == false)
        {
          alert(strMsgInvalidID);
          objTxtId.select();
          return false;
        }
      }
      //Validacion de Password
      if (objTxtPwd.value == '')
      {
        alert(strMsgPassword);
        objTxtPwd.select();
        return false;
      }
      //Validacion de confirmacion de Password
      if (objTxtPwd.value != objTxtConfirmPwd.value)
      {
        alert(strMsgPasswordMatch);
        objTxtConfirmPwd.select();
        return false;
      }
      //Validacion de nombre
      if (objTxtFirstName.value.trim() == '')
      {
        alert(strMsgFirstName);
        objTxtFirstName.select();
        return false;
      }
      //Validacion de apellido
      if (objTxtLastName.value.trim() == '')
      {
        alert(strMsgLastName);
        objTxtLastName.select();
        return false;
      }
      //Validacion de E-Mail
      if (objTxtEMail.value.trim() != '')
      {
        filter = /^([0-9a-zA-Z]+[-._+&amp;])*[0-9a-zA-Z]+@([-0-9a-zA-Z]+[.])+[a-zA-Z]{2,6}$/;
            
        if (filter.test(objTxtEMail.value.trim()) == false)
        {
          alert(strMsgEMail);
          objTxtEMail.select();
          return false;
        }       
      }
      if (ValidOrganizationChkAssigned('AddUserChksOrg') == false)
      {
        alert(strMsgAssignOrganizations);        
        return false;
      }

      //*******************************************************************//
      // Valido que la base da datos no se encuentre modificada manualmente
      if (validateDataBaseIsModificated() == true)
        return false;

      // Valido cantidad de usuarios segun licencia
      if (pValidateVerticals == true)
      {
        var objInputs;
        var objInputsSelect;
        var objInput;
        var objInputSelect
        var strMessageUserType;
        var isAnyVerticalAssigned;

        // Search on all Input Tags.
        objInputs = document.getElementsByTagName('input');
        isAnyVerticalAssigned = false;
        for (var i = 0; i < objInputs.length - 1; i++)
        {
          // Get Input that acts as a Filter
          objInput = objInputs.item(i);
          if (objInput.type.toUpperCase() == 'CHECKBOX')
          {
            // Consulto por el nodo Padre y por el nodo propio
            if (objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == 'chkSelVertical')
            {
              if (objInput.checked == true)
              {
                isAnyVerticalAssigned = true; // indico que al menos un vertical se encuentra asignado

                // controlo licencia en PECTRA BPM Suite
                if (objInput.parentNode.getAttribute('verticalName').toUpperCase() == 'PECTRA' || objInput.parentNode.getAttribute('verticalName').toUpperCase() == 'PECTRA BPM SUITE')
                {
                  if (validateLicense('PECTRA BPM Suite', 'UsrMain', msgTheLicense, msgTheUserTypeMain) == false)
                  {
                    return false; //cancelo el submit de la pagina
                  }
                }

                // controlo licencia en Verticales
                objInputsSelect = document.getElementsByTagName('select');
                for (var j = 0; j < objInputsSelect.length; j++)
                {
                  // Get Input that acts as a Filter
                  objInputSelect = objInputsSelect.item(j);
                  if (objInputSelect.type.toUpperCase() == 'SELECT-ONE')
                  {                  
                    if (objInputSelect.getAttribute('verticalName') == objInput.parentNode.getAttribute('verticalName'))
                    {
                      switch (objInputSelect.getAttribute('userTypeName').toUpperCase())
                      {
                        case 'USRMAIN':
                          strMessageUserType = msgTheUserTypeMain;
                          break;
                        case 'USRSECONDARY':
                          strMessageUserType = msgTheUserTypeSecondary;
                          break;
                        default:
                          strMessageUserType = msgTheUserTypeMain;
                          break;
                      }
                      
                      // verifico si la licencia permite agregar un nuevo usuario al vertical
                      if (validateLicense(objInputSelect.getAttribute('verticalName'), objInputSelect.getAttribute('userTypeName'), msgTheLicense, strMessageUserType) == false)
                      {
                        objInputSelect.focus(); //asigno el foco al objeto "select"
                        return false; //cancelo el submit de la pagina
                      }
                    }
                  } //-End If-
                } //-End For-
              } //-End If-
            }
          }
        }
        
        if (isAnyVerticalAssigned == false)
        {
          alert(strMsgAssignVerticals + '.');
          return false;
        }
      } //-End  if (pValidateVerticals == true)-
      //*******************************************************************//

      return true;     
    }

    // Valida que se halla seleccionado algun CheckBox de las grillas
    function ValidOrganizationChkAssigned(pChkCategory)
    {
      var objInputs;
      var objInput;

      // Search on all Input Tags.
      objInputs = document.getElementsByTagName('input');
      for (var i = 0; i < objInputs.length - 1; i++)
      {
        // Get Input that acts as a Filter
        objInput = objInputs.item(i);
        if (objInput.type.toUpperCase() == 'CHECKBOX')
        {
          // Consulto por el nodo Padre y por el nodo propio
          if ((objInput.parentNode.getAttribute('category') != null && objInput.parentNode.getAttribute('category') == pChkCategory) || (objInput.getAttribute('category') != null && objInput.getAttribute('category') == pChkCategory))
          {
            if (objInput.checked == true)
              return true;
          }
        }
      }      
      return false;
    }
    
    // Modifico el atributo userTypeName de los checkbox
    function ChangeUserType(pSelectElement)
    {
      pSelectElement.setAttribute('userTypeName', pSelectElement.options[pSelectElement.selectedIndex].value);
    }
    
    // Valido si una Organizacion tiene Unidades Operacionales asignadas que se encuentren acticas
    function validateLicense(pVerticalName, pUserTypeName, msgTheLicense, msgTheUserType)
    {
      var rand;
      var blnIsValidNewUser;
      var ea = new easyAjax();

      rand = Math.random();
      blnIsValidNewUser = false;

      ea.openText("ValidateUserCountByVerticalByUserType.aspx?VerticalName=" + pVerticalName + "&UserTypeName=" + pUserTypeName + "&nocache=" + rand, function(szResult){
        if (szResult.toUpperCase() == 'TRUE')
          blnIsValidNewUser = true;
      });

      if (blnIsValidNewUser == false) //si la licencia no permite mas usuarios informo al usuario
      {
        alert(msgTheLicense + ' \'' + pVerticalName + '\' ' + msgTheUserType + '.');
      }
      
      return blnIsValidNewUser;
    }
    
    // Valido si la base de datos fue manipulada en forma manual
    function validateDataBaseIsModificated()
    {
      var blnResult;
      var ea = new easyAjax();

      rand = Math.random();
      blnIsModificated = false;

      ea.openText("ValidateDataBaseIsCorrect.aspx", function(szResult){
        if (szResult.toUpperCase() == 'TRUE')
          blnIsModificated = true;
      });
      
      if (blnIsModificated == true)
        alert('The relationship between users and verticals has been changed by one malicious user.\n\rPlease contact to Pectra Support.');
      
      return blnIsModificated;
    }
    //]]>
</script>    
  <!-- Logo de Pectra y Seccion Agregar Usuarios -->
  <table border="0" cellpadding="0" cellspacing="0" class="tblTitle">
    <tr>
      <td class="SecTitle">
        <img alt="" class="PectraLogo<% = ((Request.ServerVariables["HTTP_USER_AGENT"].IndexOf("MSIE") > -1) ? "IE": "").ToString() %>"
          src="<% = Page.ResolveUrl(string.Format("~/Images/PectraLogo.{0}.png", Page.Theme)) %>" />
        <span id="spanTitle" runat="server">Usuario</span>
      </td>
    </tr>
  </table>
  <!-- Separador -->
  <hr class="Separator" />
  <!-- Panel de Filtro -->
  <asp:Panel ID="pnlFilter" CssClass="Filter" runat="server" Width="100%" EnableViewState="False">
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td id="tdFilterCaption" class="FilterCaption">
          <img id="imgFilter" alt="" src="../../Images/UsrProp16.gif"
            class="Filter" />
          <span id="spanAddUsers" runat="server">Agregar Usuario </span>
        </td>
      </tr>
      <tr>
        <td id="tdFilterContent" class="FilterContent" colspan="2">
          <table border="0" cellpadding="0" cellspacing="1" style="width: 100%;">
            <tr>
              <td class="Caption" align="right">
                <span id="spanUserId" runat="server">Id: </span>
              </td>
              <td>
                <asp:TextBox ID="txtUsrId" SkinID="Filter" runat="server" MaxLength="25" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanPwd" runat="server">Contrasea:</span>
              </td>
              <td>
                <asp:TextBox ID="txtUsrPwd" SkinID="Filter" runat="server" MaxLength="255" TextMode="Password"
                  EnableViewState="False"></asp:TextBox>&nbsp;
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanPwdConfirm" runat="server">Confirmar contrasea:</span>
              </td>
              <td>
                <asp:TextBox ID="txtUsrConfirmPwd" SkinID="Filter" runat="server" MaxLength="255"
                  TextMode="Password" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanName" runat="server">Nombre:</span>
              </td>
              <td>
                <asp:TextBox ID="txtUsrFirstName" SkinID="Filter" runat="server" MaxLength="150"
                  EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanLastName" runat="server">Apellido:</span>
              </td>
              <td>
                <asp:TextBox ID="txtUsrLastName" SkinID="Filter" runat="server" MaxLength="150" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanEmail" runat="server">E-Mail:</span>
              </td>
              <td>
                <asp:TextBox ID="txtUsrEMail" SkinID="Filter" runat="server" MaxLength="255" EnableViewState="False"></asp:TextBox>
              </td>
            </tr>
            <tr>
              <td class="Caption" align="right">
                <span id="spanGenero" runat="server">Genero:</span>
              </td>
              <td>
                <asp:RadioButton ID="rdoMale" SkinID="Filter" GroupName="Gender" Text="Masculino"
                  Checked="true" runat="server" EnableViewState="false" />
                &nbsp;
                <asp:RadioButton ID="rdoFemale" SkinID="Filter" GroupName="Gender" Text="Femenino"
                  runat="server" EnableViewState="false" />
              </td>
            </tr>
          </table>
        </td>
      </tr>
    </table>
    <br />
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td id="td1" class="FilterCaption">
          <img id="img1" alt="" src="../../Images/ProfUsers16.gif"
            class="Filter" />
          <span id="spanAsigOrgs" runat="server">Asignar Organizacion</span>
        </td>
        <td style="width: 70%" class="FilterCaptionContinue" align="right">
          <asp:Button ID="btnUnCheckAllOrgs" runat="server" SkinID="Filter" Text="Desmarcar Todos" EnableViewState="False" />
          <asp:Button ID="btnCheckAllOrgs" runat="server" SkinID="Filter" Text="Marcar Todos" EnableViewState="False" />
          <asp:Button ID="btnReverseOrgs" runat="server" SkinID="Filter" Text="Invertir" EnableViewState="False" />
        </td>
      </tr>
      <tr>
        <td colspan = "2">
          <asp:GridView ID="gridOrganizaciones" runat="server" AllowPaging="True" AllowSorting="True"
            AutoGenerateColumns="False" OnDataBound="gridOrg_DataBound" OnRowCreated="gridOrg_RowCreated"
            SkinID="Filter" >
            <PagerSettings FirstPageImageUrl="~/Images/NavFirstPage.gif" FirstPageText="Primero"
              LastPageImageUrl="~/Images/NavLastPage.gif" LastPageText="Ultimo" Mode="NumericFirstLast"
              PageButtonCount="10" />
            <Columns>
              <asp:BoundField DataField="OrgId" HeaderText="Id de Organizaci&#243;n" ReadOnly="True"
                SortExpression="OrgId">
                <ItemStyle Width="35%" Wrap="False" />
              </asp:BoundField>
              <asp:BoundField DataField="OrgDescription" HeaderText="Descripci&#243;n" SortExpression="OrgDescription">
                <ItemStyle Width="45%" />
              </asp:BoundField>
              <asp:TemplateField HeaderText="Seleccionar">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                  <asp:CheckBox ID="chkSelOrg" runat="server" />                  
                </ItemTemplate>
              </asp:TemplateField>
            </Columns>
          </asp:GridView>
          <asp:ObjectDataSource ID="oDSOrgSA" runat="server" TypeName="Pectra.OrgInterface.Engine" SelectMethod="OrgGetAll"></asp:ObjectDataSource>
          <asp:ObjectDataSource ID="oDSOrgA" runat="server" TypeName="Pectra.OrgInterface.Engine" SelectMethod="OrgGetAllByUser"></asp:ObjectDataSource>
        </td>
      </tr>
    </table>
    
    <div id="divVerticals" runat="server" visible="false" enableviewstate="false">
    <!-- Separador -->
    <hr class="Separator" />
    <!-- Grilla de Verticales -->
    <table border="0" cellpadding="2" cellspacing="0" style="width: 100%">
      <tr>
        <td id="td2" class="FilterCaption">
          <img id="img2" alt="" src="../../Images/ProfUsers16.gif"
            class="Filter" />
          <span id="spanAssignVerticals" runat="server">Asignar Verticales</span>
        </td>
        <td style="width: 70%" class="FilterCaptionContinue" align="right">
          <asp:Button ID="btnUnCheckAllVerticals" runat="server" SkinID="Filter" Text="Desmarcar Todos" EnableViewState="False" />
          <asp:Button ID="btnCheckAllVerticals" runat="server" SkinID="Filter" Text="Marcar Todos" EnableViewState="False" />
          <asp:Button ID="btnReverseVerticals" runat="server" SkinID="Filter" Text="Invertir" EnableViewState="False" />
        </td>
      </tr>
      <tr>
        <td colspan = "2">
          <asp:GridView ID="gridVerticals" runat="server"
            AutoGenerateColumns="False" SkinID="FilterNoPaging"
            OnRowDataBound="gridVerticals_RowDataBound" >
            <PagerSettings FirstPageImageUrl="~/Images/NavFirstPage.gif" FirstPageText="First"
              LastPageImageUrl="~/Images/NavLastPage.gif" LastPageText="Last" Mode="NumericFirstLast"
              PageButtonCount="10" />
            <Columns>
              <asp:BoundField DataField="Id" HeaderText="Id de Vertical" ReadOnly="True"
                SortExpression="Id">
                <ItemStyle Width="35%" Wrap="False" />
              </asp:BoundField>
              <asp:TemplateField HeaderText="Tipo de Usuario">
                <ItemStyle HorizontalAlign="Center" Width="45%" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                  <asp:DropDownList ID="ddlUserType" runat="server" SkinID="Filter" verticalName='<%# Eval("Id") %>' userTypeName="" onchange="javascript:ChangeUserType(this)" EnableViewState="false"></asp:DropDownList>               
                </ItemTemplate>
              </asp:TemplateField>
              <asp:TemplateField HeaderText="Seleccionar">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                  <asp:CheckBox ID="chkSelVertical" runat="server" category="chkSelVertical" verticalName='<%# Eval("Id") %>' />                  
                </ItemTemplate>
              </asp:TemplateField>
            </Columns>
          </asp:GridView>
        </td>
      </tr>
    </table>
    </div>
    
    <!-- Botones de confirmacion -->
    <table width="100%">
      <tr>
        <td align="right" colspan="2">
          <br />
          <hr class="Separator" />
          <asp:Button ID="btnOk" runat="server" SkinID="Filter" Text="Aceptar" EnableViewState="False"
            OnClick="btnOk_Click" />
          <asp:Button ID="btnCancel" runat="server" SkinID="Filter" Text="Cancelar" EnableViewState="False"
            OnClick="btnCancel_Click" CausesValidation="False" />
          <hr class="Separator" />
        </td>
      </tr>
    </table>    
  </asp:Panel>
</asp:Content>
